<?php

namespace App\Http\Controllers;

use App\Models\Tipe36;
use Illuminate\Http\Request;

class Tipe36Controller extends Controller
{
    public function index()
    {
        $units = Tipe36::all();
        return view('admin.tipe36.index', compact('units'));
    }

    public function create()
    {
        return view('admin.tipe36.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'blok' => 'required|string|max:255',
            'status' => 'required|string|max:255',
            'luas_tanah' => 'required|numeric',
            'luas_bangunan' => 'required|numeric',
            'kamar_tidur' => 'required|integer',
            'kamar_mandi' => 'required|integer',
            'kamar_pembantu' => 'required|integer',
            'carport' => 'required|integer',
            'dapur' => 'required|integer',
            'daya_listrik' => 'required|string',
        ]);
        Tipe36::create($data);
        return redirect()->route('admin.tipe36.index')->with('success', 'Unit berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $unit = Tipe36::findOrFail($id);
        return view('admin.tipe36.edit', compact('unit'));
    }

    public function update(Request $request, $id)
    {
        $unit = Tipe36::findOrFail($id);
        $data = $request->validate([
            'blok' => 'required|string|max:255',
            'status' => 'required|string|max:255',
            'luas_tanah' => 'required|numeric',
            'luas_bangunan' => 'required|numeric',
            'kamar_tidur' => 'required|integer',
            'kamar_mandi' => 'required|integer',
            'kamar_pembantu' => 'required|integer',
            'carport' => 'required|integer',
            'dapur' => 'required|integer',
            'daya_listrik' => 'required|string',
        ]);
        $unit->update($data);
        return redirect()->route('admin.tipe36.index')->with('success', 'Unit berhasil diupdate.');
    }

    public function show($id)
    {
        $unit = Tipe36::findOrFail($id);
        return view('admin.tipe36.show', compact('unit'));
    }

    public function destroy($id)
    {
        $unit = Tipe36::findOrFail($id);
        $unit->delete();
        return redirect()->route('admin.tipe36.index')->with('success', 'Unit berhasil dihapus.');
    }
} 