# Contributing to laravel-10-adminlte

Thank you for considering contributing to laravel-10-adminlte! We welcome contributions from the community to make our project better.

## Code of Conduct

Please note that this project is released with a [Contributor Code of Conduct](CODE_OF_CONDUCT.md). By participating in this project you agree to abide by its terms.

## How to Contribute

We appreciate contributions in the form of bug reports, feature requests, code changes, and more. Here's a guide on how you can contribute:

### Reporting Issues

If you encounter any issues with the project, please check if the issue already exists in our [issue tracker](https://github.com/Nihirz/laravel-10-adminlte/issues). If not, please [open a new issue](https://github.com/Nihirz/laravel-10-adminlte/issues/new) and include the following information:

- A descriptive title
- A detailed description of the issue, including steps to reproduce
- Your operating system and version
- Your project version or commit hash

### Feature Requests

If you have an idea for a new feature, please [open a new issue](https://github.com/Nihirz/laravel-10-adminlte/issues/new) and include:

- A clear and concise description of the feature
- Any relevant use cases or examples

### Pull Requests

If you want to contribute code changes, feel free to fork the repository and submit a pull request. Follow these steps:

1. Fork the repository to your own GitHub account.
2. Create a new branch for your feature or bug fix: `git checkout -b feature-name`.
3. Make your changes and commit them with a clear message.
4. Push your branch to your fork: `git push origin feature-name`.
5. Submit a pull request to the main repository.

### Coding Guidelines

Please adhere to our coding style and guidelines. If your contribution involves documentation, make sure to update the relevant documentation as well.

### Review Process

All contributions will be reviewed by project maintainers. Feedback and changes may be requested before merging.

## License

By contributing to this project, you agree that your contributions will be licensed under the [project license](LICENSE).

Thank you for your contributions!

Nihir Zala
