
<?php $__env->startSection('content'); ?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Arial', sans-serif;
        line-height: 1.6;
    }

    /* Top Navigation Bar */
    .top-navbar {
        background-color: #1a1a1a;
        padding: 0.3rem 0;
        font-size: 0.8rem;
    }

    .top-navbar .container {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .top-navbar .contact-info {
        color: #ccc;
    }

    .top-navbar .social-links a {
        color: #ccc;
        margin-left: 1rem;
        font-size: 0.9rem;
    }

    /* Main Navigation */
    .main-navbar {
        background-color: #ffffff;
        padding: 1rem 0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .navbar-brand {
        color: #4CAF50 !important;
        font-weight: bold;
        font-size: 1.1rem;
        display: flex;
        align-items: center;
    }

    .navbar-brand i {
        color: #4CAF50;
        margin-right: 8px;
        font-size: 1.2rem;
    }

    .main-navbar .navbar-nav {
        margin: 0 auto;
    }

    .main-navbar .navbar-nav .nav-link {
        color: #333 !important;
        margin: 0 1.5rem;
        font-size: 0.95rem;
        font-weight: 500;
        padding: 0.5rem 0;
    }

    .main-navbar .navbar-nav .nav-link:hover {
        color: #4CAF50 !important;
    }

    .btn-hubungi {
        background-color: #ff5722;
        color: white;
        border: none;
        padding: 0.6rem 1.8rem;
        border-radius: 25px;
        font-size: 0.9rem;
        font-weight: 600;
    }

    .btn-hubungi:hover {
        background-color: #e64a19;
        color: white;
    }

    /* Hero Section */
    .hero-section {
        background: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), 
                    url('/placeholder.svg?height=400&width=1200');
        background-size: cover;
        background-position: center;
        color: white;
        padding: 4rem 0;
        min-height: 400px;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
    }

    .hero-content h1 {
        font-size: 3rem;
        font-weight: 700;
        margin-bottom: 1rem;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
    }

    .hero-content p {
        font-size: 1.2rem;
        font-weight: 400;
        text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
    }

    /* Career Section */
    .career-section {
        background-color: #e8f5e8;
        padding: 4rem 0;
    }

    .career-intro {
        margin-bottom: 2rem;
    }

    .career-label {
        color: #666;
        font-size: 1rem;
        margin-bottom: 0.5rem;
        font-weight: 500;
    }

    .career-title {
        color: #333;
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 2rem;
    }

    .career-description {
        color: #666;
        font-size: 1rem;
        line-height: 1.7;
        margin-bottom: 1.5rem;
    }

    /* Job Listings */
    .job-listings {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .job-card {
        background: white;
        border-radius: 10px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .job-header {
        padding: 1.5rem;
        cursor: pointer;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-bottom: 1px solid #f0f0f0;
    }

    .job-header:hover {
        background-color: #f8f9fa;
    }

    .job-title {
        font-size: 1.1rem;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .job-status {
        font-size: 0.9rem;
        font-weight: 600;
    }

    .job-status.open {
        color: #4CAF50;
    }

    .job-status.closed {
        color: #f44336;
    }

    .job-toggle {
        color: #666;
        font-size: 1.2rem;
        transition: transform 0.3s ease;
    }

    .job-toggle.active {
        transform: rotate(180deg);
    }

    .job-content {
        padding: 0 1.5rem;
        max-height: 0;
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .job-content.active {
        max-height: 500px;
        padding: 1.5rem;
    }

    .job-description {
        color: #666;
        font-size: 0.95rem;
        line-height: 1.6;
        margin-bottom: 1.5rem;
    }

    .job-section {
        margin-bottom: 1.5rem;
    }

    .job-section h5 {
        color: #333;
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 0.8rem;
    }

    .job-section ul {
        list-style: none;
        padding: 0;
    }

    .job-section li {
        color: #666;
        font-size: 0.9rem;
        margin-bottom: 0.5rem;
        padding-left: 1rem;
        position: relative;
    }

    .job-section li::before {
        content: '•';
        color: #4CAF50;
        position: absolute;
        left: 0;
    }

    .contact-info p {
        margin: 0;
        color: #666;
        font-size: 0.9rem;
        line-height: 1.5;
    }

    .btn-apply {
        background-color: #ff5722;
        color: white;
        border: none;
        padding: 0.8rem 2rem;
        border-radius: 25px;
        font-weight: 600;
        font-size: 0.95rem;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .btn-apply:hover {
        background-color: #e64a19;
    }

    /* Footer */
    .footer {
        background-color: #1a1a1a;
        color: #ccc;
        padding: 3rem 0 1rem;
    }

    .footer h5 {
        color: #4CAF50;
        font-size: 1.2rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
    }

    .footer p, .footer li {
        font-size: 0.9rem;
        line-height: 1.6;
        margin-bottom: 0.5rem;
    }

    .footer a {
        color: #ccc;
        text-decoration: none;
    }

    .footer a:hover {
        color: #4CAF50;
    }

    .footer .social-icons a {
        color: #4CAF50;
        font-size: 1.5rem;
        margin-right: 1rem;
    }

    .footer-bottom {
        border-top: 1px solid #333;
        margin-top: 2rem;
        padding-top: 1rem;
    }

    .scroll-top {
        position: fixed;
        bottom: 2rem;
        right: 2rem;
        background-color: #4CAF50;
        color: white;
        border: none;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
        box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .scroll-top:hover {
        background-color: #45a049;
        transform: translateY(-2px);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .hero-content h1 {
            font-size: 2.2rem;
        }
        
        .career-title {
            font-size: 1.8rem;
        }
        
        .top-info {
            flex-direction: column;
            gap: 0.5rem;
        }
        
        .top-navbar {
            text-align: center;
        }
        
        .main-navbar .navbar-nav .nav-link {
            margin: 0 0.5rem;
        }

        .job-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 0.5rem;
        }
    }
</style>

<!-- Hero Section -->
<section class="hero-section" style="background: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), url('<?php echo e(asset('karir.png')); ?>'); background-size: contain; background-position: center; color: white; padding: 4rem 0; min-height: 400px; display: flex; align-items: center; justify-content: center; text-align: center;">
    <div class="container">
        <div class="hero-content">
            <h1>Bergabung Bersama Kami</h1>
            <p>Dapatkan pengalaman baru di dunia property</p>
        </div>
    </div>
</section>

<!-- Career Section -->
<section class="career-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="career-intro">
                    <p class="career-label" style="font-weight: bold; font-size: 1.5rem; color: #81987E;">Karir Bersama MGG</p>
                    <h2 class="career-title">Membangun Karir Lebih Baik Lagi</h2>
                    
                    <p class="career-description">
                        Melalui proyek perumahan Maskarebat Green Garden, kami mengundang anda untuk bergabung menjadi bagian dari kami.
                    </p>
                    
                    <p class="career-description">
                        Kami menawarkan berbagai peluang karir yang akan membantu Anda untuk mengembangkan dan memperluas keahlian Anda. Bergabunglah dengan kami sesuai kriteria new graduate, magang atau sebagai profesional yang sudah berpengalaman. Cari tahu pekerjaan mana yang paling cocok untuk Anda.
                    </p>
                    
                    <p class="career-description">
                        Fondasi kami, idemu, bersama-sama kita maju dan berkembang untuk menciptakan masa depan bersama.
                    </p>
                </div>
            </div>
            
            <div class="col-lg-6">
                <div class="job-listings">
                    <!-- Marketing Executive -->
                    <div class="job-card">
                        <div class="job-header" onclick="toggleJob(0)">
                            <div>
                                <h4 class="job-title">Marketing Executive</h4>
                                <span class="job-status open">Open</span>
                            </div>
                            <i class="fas fa-chevron-down job-toggle active" id="toggle-0"></i>
                        </div>
                        <div class="job-content active" id="content-0">
                            <p class="job-description">
                                Bergabunglah dengan kami sebagai Marketing Executive untuk mengembangkan strategi pemasaran yang inovatif dan efektif.
                            </p>
                            <button class="btn-apply">Apply Now</button>
                        </div>
                    </div>

                    <!-- Digital Marketing -->
                    <div class="job-card">
                        <div class="job-header" onclick="toggleJob(1)">
                            <div>
                                <h4 class="job-title">Digital Marketing</h4>
                            </div>
                            <i class="fas fa-chevron-down job-toggle" id="toggle-1"></i>
                        </div>
                        <div class="job-content" id="content-1">
                            <p class="job-description">
                                Posisi Digital Marketing untuk mengelola kampanye digital dan media sosial perusahaan.
                            </p>
                            <button class="btn-apply">Apply Now</button>
                        </div>
                    </div>

                    <!-- Supervisor Marketing -->
                    <div class="job-card">
                        <div class="job-header" onclick="toggleJob(2)">
                            <div>
                                <h4 class="job-title">Supervisor Marketing</h4>
                            </div>
                            <i class="fas fa-chevron-down job-toggle" id="toggle-2"></i>
                        </div>
                        <div class="job-content" id="content-2">
                            <p class="job-description">
                                Supervisor Marketing untuk memimpin tim marketing dan mengawasi strategi pemasaran.
                            </p>
                            <button class="btn-apply">Apply Now</button>
                        </div>
                    </div>

                    <!-- Agent Penjualan (Freelance) -->
                    <div class="job-card">
                        <div class="job-header" onclick="toggleJob(3)">
                            <div>
                                <h4 class="job-title">Agent Penjualan (Freelance)</h4>
                            </div>
                            <i class="fas fa-chevron-down job-toggle" id="toggle-3"></i>
                        </div>
                        <div class="job-content" id="content-3">
                            <p class="job-description">
                                Bergabunglah dengan kami sebagai posisi Agent Penjualan (Freelance). Bisa untuk agent dibawah naungan perusahaan atau agent perorangan (sendiri).
                            </p>
                            
                            <div class="job-section">
                                <h5>Insentif:</h5>
                                <ul>
                                    <li>Fee Marketing</li>
                                    <li>Fee Closing</li>
                                </ul>
                            </div>
                            
                            <div class="job-section">
                                <h5>Syarat:</h5>
                                <ul>
                                    <li>Foto Copy KTP</li>
                                    <li>Mengisi Formulir</li>
                                    <li>Bergabung Grup Whatsapp</li>
                                </ul>
                            </div>
                            
                            <div class="job-section">
                                <h5>Cara:</h5>
                                <div class="contact-info">
                                    <p>Hubungi whatsapp kami atau datang langsung ke kantor pemasaran Maskarebat Green Garden.</p>
                                    <p><strong>WhatsApp Official: 0851-7958-8921</strong></p>
                                </div>
                            </div>
                            
                            <button class="btn-apply">Apply Now</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?> 

<?php $__env->startPush('scripts'); ?>
<script>
    function toggleJob(index) {
        const content = document.getElementById(`content-${index}`);
        const toggle = document.getElementById(`toggle-${index}`);
        
        // Close all other job contents
        for (let i = 0; i < 4; i++) {
            if (i !== index) {
                document.getElementById(`content-${i}`).classList.remove('active');
                document.getElementById(`toggle-${i}`).classList.remove('active');
            }
        }
        
        // Toggle current job content
        content.classList.toggle('active');
        toggle.classList.toggle('active');
    }

    function scrollToTop() {
        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    }

    // Show/hide scroll to top button
    window.addEventListener('scroll', function() {
        const scrollTop = document.querySelector('.scroll-top');
        if (window.pageYOffset > 300) {
            scrollTop.style.display = 'flex';
        } else {
            scrollTop.style.display = 'none';
        }
    });

    // Initialize with Agent Penjualan expanded
    document.addEventListener('DOMContentLoaded', function() {
        // Agent Penjualan is already expanded by default in HTML
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\programming\web-perumahan\resources\views/frontend/karir.blade.php ENDPATH**/ ?>