<form method="POST" action="<?php echo e($action); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <?php if($isEdit): ?>
        <?php echo method_field('PUT'); ?>
    <?php endif; ?>
    <div class="mb-3">
        <label class="font-weight-bold">Nama Promo</label>
        <input type="text" name="nama" class="form-control" placeholder="Misalkan, Promo Bulan Ini" value="<?php echo e(old('nama', $promo->nama ?? '')); ?>">
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Caption</label>
        <input type="text" name="caption" class="form-control" placeholder="Misalkan, Dapatkan promo khusus kamu aja" value="<?php echo e(old('caption', $promo->caption ?? '')); ?>">
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Jenis Promo</label>
        <div id="jenis-promo-list">
            <?php
                $jenisList = old('jenis_promo', $promo->jenis_promo ?? []);
                if (is_string($jenisList)) $jenisList = json_decode($jenisList, true) ?? [];
                if (empty($jenisList)) $jenisList = [''];
            ?>
            <?php $__currentLoopData = $jenisList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $jenis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="input-group mb-2 jenis-promo-item">
                <select name="jenis_promo[]" class="form-control">
                    <option value="">Pilih Jenis Promo</option>
                    <option value="Tanpa DP" <?php echo e($jenis == 'Tanpa DP' ? 'selected' : ''); ?>>Tanpa DP</option>
                    <option value="Gratis Biaya KPR" <?php echo e($jenis == 'Gratis Biaya KPR' ? 'selected' : ''); ?>>Gratis Biaya KPR</option>
                    <option value="Gratis Biaya Pajak" <?php echo e($jenis == 'Gratis Biaya Pajak' ? 'selected' : ''); ?>>Gratis Biaya Pajak</option>
                    <option value="Gratis SHM" <?php echo e($jenis == 'Gratis SHM' ? 'selected' : ''); ?>>Gratis SHM</option>
                    <option value="Air Conditioner (AC)" <?php echo e($jenis == 'Air Conditioner (AC)' ? 'selected' : ''); ?>>Air Conditioner (AC)</option>
                    <option value="TV 24 inch" <?php echo e($jenis == 'TV 24 inch' ? 'selected' : ''); ?>>TV 24 inch</option>
                    <option value="Subisidi Angsuran 1 Tahun" <?php echo e($jenis == 'Subisidi Angsuran 1 Tahun' ? 'selected' : ''); ?>>Subisidi Angsuran 1 Tahun</option>
                </select>
                <button type="button" class="btn btn-danger btn-remove-jenis" onclick="removeJenisPromo(this)">-</button>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="input-group mb-2">
            <input type="text" id="jenis-promo-custom" class="form-control" placeholder="Tambah Jenis Promo">
            <button type="button" class="btn btn-secondary" onclick="addJenisPromo()">+</button>
        </div>
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Gambar Promo</label><br />
        <input type="file" name="gambar">
        <?php if(!empty($promo->gambar)): ?>
            <img src="<?php echo e(asset('storage/' . $promo->gambar)); ?>" alt="Promo" style="max-width:120px;max-height:120px;margin-top:8px;border-radius:8px;">
        <?php endif; ?>
    </div>
    <div class="text-right">
        <button type="submit" class="btn btn-warning">SIMPAN</button>
    </div>
</form>
<script>
function addJenisPromo() {
    var val = document.getElementById('jenis-promo-custom').value;
    var div = document.createElement('div');
    div.className = 'input-group mb-2 jenis-promo-item';
    if (val) {
        div.innerHTML = `<input type=\"text\" name=\"jenis_promo[]\" class=\"form-control\" value="${val}">
            <button type=\"button\" class=\"btn btn-danger btn-remove-jenis\" onclick=\"removeJenisPromo(this)\">-</button>`;
    } else {
        div.innerHTML = `<select name=\"jenis_promo[]\" class=\"form-control\">
            <option value=\"\">Pilih Jenis Promo</option>
            <option value=\"Tanpa DP\">Tanpa DP</option>
            <option value=\"Gratis Biaya KPR\">Gratis Biaya KPR</option>
            <option value=\"Gratis Biaya Pajak\">Gratis Biaya Pajak</option>
            <option value=\"Gratis SHM\">Gratis SHM</option>
            <option value=\"Air Conditioner (AC)\">Air Conditioner (AC)</option>
            <option value=\"TV 24 inch\">TV 24 inch</option>
            <option value=\"Subisidi Angsuran 1 Tahun\">Subisidi Angsuran 1 Tahun</option>
        </select>
        <button type=\"button\" class=\"btn btn-danger btn-remove-jenis\" onclick=\"removeJenisPromo(this)\">-</button>`;
    }
    document.getElementById('jenis-promo-list').appendChild(div);
    document.getElementById('jenis-promo-custom').value = '';
}
function removeJenisPromo(btn) {
    var list = document.getElementById('jenis-promo-list');
    if (list.children.length > 1) {
        btn.parentElement.remove();
    }
}
</script> <?php /**PATH C:\programming\web-perumahan\resources\views/admin/gambarpromo/form.blade.php ENDPATH**/ ?>