

<?php $__env->startSection('content'); ?>
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Arial', sans-serif;
        line-height: 1.6;
    }

    /* Top Navigation Bar */
    .top-navbar {
        background-color: #1a1a1a;
        padding: 0.3rem 0;
        font-size: 0.8rem;
    }

    .top-navbar .container {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .top-navbar .contact-info {
        color: #ccc;
    }

    .top-navbar .social-links a {
        color: #ccc;
        margin-left: 1rem;
        font-size: 0.9rem;
    }

    /* Main Navigation */
    .main-navbar {
        background-color: #ffffff;
        padding: 1rem 0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .navbar-brand {
        color: #4CAF50 !important;
        font-weight: bold;
        font-size: 1.1rem;
        display: flex;
        align-items: center;
    }

    .navbar-brand i {
        color: #4CAF50;
        margin-right: 8px;
        font-size: 1.2rem;
    }

    .main-navbar .navbar-nav {
        margin: 0 auto;
    }

    .main-navbar .navbar-nav .nav-link {
        color: #333 !important;
        margin: 0 1.5rem;
        font-size: 0.95rem;
        font-weight: 500;
        padding: 0.5rem 0;
    }

    .main-navbar .navbar-nav .nav-link:hover {
        color: #4CAF50 !important;
    }

    .btn-hubungi {
        background-color: #ff5722;
        color: white;
        border: none;
        padding: 0.6rem 1.8rem;
        border-radius: 25px;
        font-size: 0.9rem;
        font-weight: 600;
    }

    .btn-hubungi:hover {
        background-color: #e64a19;
        color: white;
    }
    
    /* Hero Section */
    .hero-section {
        background: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), 
                    url('/placeholder.svg?height=300&width=1200');
        background-size: cover;
        background-position: center;
        color: white;
        padding: 3rem 0;
        min-height: 300px;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
    }

    .hero-content h1 {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
    }

    .hero-content p {
        font-size: 1.1rem;
        font-weight: 400;
        text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
    }

    /* Calculator Section */
    .calculator-section {
        padding: 3rem 0;
        background-color: #f8f9fa;
    }

    .calculator-card {
        background: #2196f3;
        border-radius: 15px;
        padding: 2rem;
        color: white;
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }

    .calculator-title {
        font-size: 1.2rem;
        font-weight: 600;
        margin-bottom: 1.5rem;
        color: white;
    }

    .form-group {
        margin-bottom: 1.5rem;
    }

    .form-label {
        color: white;
        font-size: 0.9rem;
        margin-bottom: 0.5rem;
        display: block;
    }

    .form-control {
        border: none;
        border-radius: 8px;
        padding: 0.8rem;
        font-size: 0.9rem;
    }

    .form-select {
        border: none;
        border-radius: 8px;
        padding: 0.8rem;
        font-size: 0.9rem;
    }

    .btn-calculate {
        background-color: #ff5722;
        color: white;
        border: none;
        padding: 0.8rem 2rem;
        border-radius: 8px;
        font-weight: 600;
        width: 100%;
        margin-top: 1rem;
    }

    .btn-calculate:hover {
        background-color: #e64a19;
    }

    .results-card {
        background: #e8f5e8;
        border-radius: 15px;
        padding: 2rem;
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }

    .results-title {
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 1.5rem;
        color: #333;
    }

    .result-item {
        display: flex;
        justify-content: space-between;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 1px solid #ddd;
    }

    .result-label {
        color: #666;
        font-size: 0.9rem;
    }

    .result-value {
        color: #333;
        font-weight: 600;
        font-size: 0.9rem;
    }

    .monthly-payment {
        background: white;
        padding: 1rem;
        border-radius: 8px;
        text-align: center;
        margin-top: 1rem;
    }

    .monthly-payment .amount {
        font-size: 1.5rem;
        font-weight: 700;
        color: #4CAF50;
    }

    /* Information Sections */
    .info-section {
        padding: 3rem 0;
        background-color: white;
    }

    .section-title {
        font-size: 1.8rem;
        font-weight: 700;
        color: #333;
        margin-bottom: 2rem;
    }

    .info-card {
        background: white;
        border-radius: 10px;
        padding: 2rem;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        margin-bottom: 2rem;
    }

    .info-list {
        list-style: none;
        padding: 0;
    }

    .info-list li {
        padding: 0.5rem 0;
        border-bottom: 1px solid #f0f0f0;
        color: #666;
        font-size: 0.9rem;
    }

    .info-list li:last-child {
        border-bottom: none;
    }

    .info-list li::before {
        content: '•';
        color: #4CAF50;
        margin-right: 0.5rem;
    }

    .table-responsive {
        margin-top: 1rem;
    }

    .table {
        font-size: 0.9rem;
    }

    .table th {
        background-color: #f8f9fa;
        color: #333;
        font-weight: 600;
        border: 1px solid #dee2e6;
    }

    .table td {
        border: 1px solid #dee2e6;
        color: #666;
    }

    .benefits-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 2rem;
        margin-top: 2rem;
    }

    .benefit-item {
        text-align: center;
        padding: 1.5rem;
        background: #f8f9fa;
        border-radius: 10px;
    }

    .benefit-icon {
        width: 60px;
        height: 60px;
        background: #4CAF50;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1rem;
        color: white;
        font-size: 1.5rem;
    }

    .benefit-title {
        font-size: 1rem;
        font-weight: 600;
        color: #333;
        margin-bottom: 0.5rem;
    }

    .benefit-desc {
        font-size: 0.85rem;
        color: #666;
    }

    .steps-list {
        counter-reset: step-counter;
        list-style: none;
        padding: 0;
    }

    .steps-list li {
        counter-increment: step-counter;
        margin-bottom: 1.5rem;
        padding-left: 3rem;
        position: relative;
        color: #666;
        font-size: 0.9rem;
        line-height: 1.6;
    }

    .steps-list li::before {
        content: counter(step-counter);
        position: absolute;
        left: 0;
        top: 0;
        background: #4CAF50;
        color: white;
        width: 2rem;
        height: 2rem;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        font-size: 0.9rem;
    }

    .btn-apply-kpr {
        background-color: #2196f3;
        color: white;
        border: none;
        padding: 1rem 3rem;
        border-radius: 25px;
        font-weight: 600;
        font-size: 1rem;
        margin-top: 2rem;
    }

    /* Footer */
    .footer {
        background-color: #1a1a1a;
        color: #ccc;
        padding: 3rem 0 1rem;
    }

    .footer h5 {
        color: #4CAF50;
        font-size: 1.2rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
    }

    .footer p, .footer li {
        font-size: 0.9rem;
        line-height: 1.6;
        margin-bottom: 0.5rem;
    }

    .footer a {
        color: #ccc;
        text-decoration: none;
    }

    .footer a:hover {
        color: #4CAF50;
    }

    .footer .social-icons a {
        color: #4CAF50;
        font-size: 1.5rem;
        margin-right: 1rem;
    }

    .footer-bottom {
        border-top: 1px solid #333;
        margin-top: 2rem;
        padding-top: 1rem;
    }

    .scroll-top {
        position: fixed;
        bottom: 2rem;
        right: 2rem;
        background-color: #4CAF50;
        color: white;
        border: none;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
        box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .scroll-top:hover {
        background-color: #45a049;
        transform: translateY(-2px);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .hero-content h1 {
            font-size: 2rem;
        }
        
        .top-info {
            flex-direction: column;
            gap: 0.5rem;
        }
        
        .top-navbar {
            text-align: center;
        }
        
        .main-navbar .navbar-nav .nav-link {
            margin: 0 0.5rem;
        }

        .benefits-grid {
            grid-template-columns: 1fr;
        }

        .calculator-section .row {
            flex-direction: column-reverse;
        }
    }
</style>

<div class="hero-section">
    <div class="container">
        <div class="hero-content">
            <h1>Simulasi KPR</h1>
            <p>Hitung aja dulu estimasi angsurannya</p>
        </div>
    </div>
</div>

<div class="calculator-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="calculator-card">
                    <h3 class="calculator-title">KPR</h3>
                    <form id="kprForm">
                        <div class="form-group">
                            <label class="form-label">Harga Properti *</label>
                            <select class="form-select" id="propertyPrice">
                                <option value="">Rp</option>
                                <option value="300000000">Rp 300.000.000</option>
                                <option value="400000000">Rp 400.000.000</option>
                                <option value="500000000">Rp 500.000.000</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Uang Muka</label>
                            <div class="row">
                                <div class="col-8">
                                    <input type="text" class="form-control" id="downPayment" placeholder="Rp">
                                </div>
                                <div class="col-4">
                                    <input type="text" class="form-control" id="downPaymentPercent" placeholder="%">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Jangka Waktu KPR</label>
                            <select class="form-select" id="loanTerm">
                                <option value="">Tahun</option>
                                <option value="5">5 Tahun</option>
                                <option value="10">10 Tahun</option>
                                <option value="15">15 Tahun</option>
                                <option value="20">20 Tahun</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Bunga Tahunan</label>
                            <div class="row">
                                <div class="col-8">
                                    <input type="text" class="form-control" id="interestRate" value="6.5">
                                </div>
                                <div class="col-4">
                                    <span class="form-control-plaintext text-white">%</span>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn-calculate" onclick="calculateKPR()">Simulasikan</button>
                    </form>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="results-card">
                    <h4 class="results-title">Angsuran Bulanan Rp</h4>
                    <div class="result-item">
                        <span class="result-label">Harga Rumah</span>
                        <span class="result-value" id="resultHousePrice">Rp 0</span>
                    </div>
                    <div class="result-item">
                        <span class="result-label">Uang Muka</span>
                        <span class="result-value" id="resultDownPayment">Rp 0</span>
                    </div>
                    <div class="result-item">
                        <span class="result-label">Jumlah Pinjaman</span>
                        <span class="result-value" id="resultLoanAmount">Rp 0</span>
                    </div>
                    <div class="result-item">
                        <span class="result-label">Jangka Waktu</span>
                        <span class="result-value" id="resultLoanTerm">0 Tahun</span>
                    </div>
                    <div class="result-item">
                        <span class="result-label">Suku Bunga</span>
                        <span class="result-value" id="resultInterestRate">0%</span>
                    </div>
                    <div class="monthly-payment">
                        <div>Cicilan Bulanan</div>
                        <div class="amount" id="monthlyPaymentAmount">Rp 0</div>
                    </div>
                    <div class="text-center mt-3">
                        <button class="btn btn-primary">Isi form untuk hasil yang lebih akurat</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bank Information Section -->
<section class="info-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="info-card">
                    <h3 class="section-title">Seputar KPR Bank</h3>
                    <ul class="info-list">
                        <li><a href="#" style="color: #4CAF50;">Syarat dan Ketentuan KPR</a></li>
                        <li>Prosedur Pengajuan</li>
                        <li>Ketentuan KPR</li>
                        <li>Cara Mengajukan</li>
                        <li>Tentang KPR</li>
                    </ul>
                </div>
            </div>
            
            <div class="col-lg-6">
                <div class="info-card">
                    <h3 class="section-title">Syarat dan Ketentuan KPR Bank</h3>
                    <h5 style="color: #4CAF50; margin-bottom: 1rem;">Syarat dan Ketentuan Umum</h5>
                    <ul class="info-list">
                        <li>WNI minimal usia 21 tahun atau sudah menikah, usia 18 tahun pada saat jatuh tempo maksimal 65 tahun</li>
                        <li>Memiliki penghasilan tetap, baik karyawan maupun wiraswasta Memiliki Rekening Tabungan di Bank yang bersangkutan</li>
                        <li>Memiliki kemampuan untuk membayar uang muka minimal 10% dari harga rumah</li>
                        <li>Bersedia di survey oleh pihak Bank</li>
                        <li>WNI dengan di Zona Internasional atau Non Residen harus</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Document Requirements Section -->
<section class="info-section" style="background-color: #f8f9fa;">
    <div class="container">
        <h3 class="section-title">Persyaratan Dokumen KPR Bank</h3>
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Dokumen</th>
                        <th>Karyawan</th>
                        <th>Wiraswasta</th>
                        <th>Profesional</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Foto Aplikasi Kredit</td>
                        <td>✓</td>
                        <td>✓</td>
                        <td>✓</td>
                    </tr>
                    <tr>
                        <td>Fotocopy KTP Suami Istri (yang sudah menikah)</td>
                        <td>✓</td>
                        <td>✓</td>
                        <td>✓</td>
                    </tr>
                    <tr>
                        <td>Fotocopy Kartu Keluarga</td>
                        <td>✓</td>
                        <td>✓</td>
                        <td>✓</td>
                    </tr>
                    <tr>
                        <td>Fotocopy Surat Nikah/Cerai (bagi yang sudah menikah/cerai)</td>
                        <td>✓</td>
                        <td>✓</td>
                        <td>✓</td>
                    </tr>
                    <tr>
                        <td>Fotocopy NPWP (SPT tahun terakhir)</td>
                        <td>✓</td>
                        <td>✓</td>
                        <td>✓</td>
                    </tr>
                    <tr>
                        <td>Slip Gaji/Surat Keterangan Penghasilan</td>
                        <td>✓</td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>Surat Keterangan Kerja</td>
                        <td>✓</td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>Fotocopy Rekening 3 bulan terakhir</td>
                        <td>✓</td>
                        <td>✓</td>
                        <td>✓</td>
                    </tr>
                    <tr>
                        <td>Pas Foto Pemohon dan Pasangan</td>
                        <td>✓</td>
                        <td>✓</td>
                        <td>✓</td>
                    </tr>
                    <tr>
                        <td>Fotocopy Akta Pendirian dan Perubahannya</td>
                        <td>-</td>
                        <td>✓</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>Fotocopy SIUP dan TDP</td>
                        <td>-</td>
                        <td>✓</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>Laporan Keuangan/Neraca 2 tahun terakhir</td>
                        <td>-</td>
                        <td>✓</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>Fotocopy Ijin Praktek</td>
                        <td>-</td>
                        <td>-</td>
                        <td>✓</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</section>

<!-- KPR Provider Section -->
<section class="info-section">
    <div class="container">
        <h3 class="section-title">Penyedia Perkreditan KPR</h3>
        <div class="row">
            <div class="col-md-6">
                <div class="info-card">
                    <h5>Beberapa bank yang KPR</h5>
                    <ul class="info-list">
                        <li>Bank Mandiri</li>
                        <li>Bank BRI</li>
                        <li>Bank BCA</li>
                        <li>Bank BNI</li>
                        <li>Bank BTN</li>
                        <li>Bank Danamon</li>
                        <li>Bank CIMB</li>
                        <li>Bank Permata</li>
                        <li>Bank Maybank</li>
                        <li>Bank OCBC NISP</li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-card">
                    <h5>Keuntungan dari KPR</h5>
                    <ul class="info-list">
                        <li>Pembayar dapat dilakukan secara mencicil</li>
                        <li>Agunan</li>
                        <li>Fleksibel</li>
                        <li>Asuransi</li>
                        <li>Investasi</li>
                        <li>Hemat</li>
                        <li>Mudah</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- KPR Benefits Section -->
<section class="info-section" style="background-color: #f8f9fa;">
    <div class="container">
        <h3 class="section-title">Kelebihan KPR</h3>
        <div class="benefits-grid">
            <div class="benefit-item">
                <div class="benefit-icon">
                    <i class="fas fa-calendar-alt"></i>
                </div>
                <h5 class="benefit-title">Jangka waktu hingga 20 tahun</h5>
                <p class="benefit-desc">Tenor panjang untuk kemudahan cicilan</p>
            </div>
            
            <div class="benefit-item">
                <div class="benefit-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <h5 class="benefit-title">Suku bunga kompetitif</h5>
                <p class="benefit-desc">Bunga yang terjangkau</p>
            </div>
            
            <div class="benefit-item">
                <div class="benefit-icon">
                    <i class="fas fa-file-alt"></i>
                </div>
                <h5 class="benefit-title">Proses cepat dengan</h5>
                <p class="benefit-desc">Pengajuan mudah dan cepat</p>
            </div>
            
            <div class="benefit-item">
                <div class="benefit-icon">
                    <i class="fas fa-home"></i>
                </div>
                <h5 class="benefit-title">Rumah impian jadi tersedia</h5>
                <p class="benefit-desc">Wujudkan rumah impian</p>
            </div>
        </div>
    </div>
</section>

<!-- How to Apply Section -->
<section class="info-section">
    <div class="container">
        <h3 class="section-title">Cara Pengajuan KPR</h3>
        <div class="info-card">
            <h5 style="color: #4CAF50; margin-bottom: 1.5rem;">Langkah Pengajuan KPR</h5>
            <ol class="steps-list">
                <li>Siapkan dokumen persyaratan sesuai ketentuan bank</li>
                <li>Datang ke bank atau KPR melalui pihak ketiga. Serahkan Pihak Bank Syariah akan melakukan verifikasi KPR di kantor</li>
                <li>Setelah itu untuk melakukan pengajuan di kantor KPR, bank akan melakukan survey ke rumah yang akan dibeli</li>
                <li>Bank akan mengecek apakah rumah memiliki surat yang lengkap</li>
                <li>Setelah semua diverifikasi dan proses selesai, maka proses pengajuan selesai</li>
            </ol>
            
            <div class="text-center">
                <button class="btn-apply-kpr">Ajukan KPR</button>
            </div>
        </div>
    </div>
</section>

<!-- About KPR Section -->
<section class="info-section" style="background-color: #f8f9fa;">
    <div class="container">
        <h3 class="section-title">Tentang KPR</h3>
        <div class="info-card">
            <p style="color: #666; line-height: 1.7; margin-bottom: 1.5rem;">
                KPR (Kredit Pemilikan Rumah) adalah fasilitas kredit yang diberikan oleh bank atau lembaga keuangan kepada nasabah perorangan yang akan membeli rumah, baik rumah baru maupun rumah bekas, atau untuk renovasi rumah.
            </p>
            <p style="color: #666; line-height: 1.7; margin-bottom: 1.5rem;">
                Dengan KPR, Anda dapat memiliki rumah impian tanpa harus membayar secara tunai. Cukup dengan membayar uang muka (down payment) dan sisanya dapat dicicil setiap bulan dalam jangka waktu tertentu sesuai kemampuan finansial Anda.
            </p>
            <p style="color: #666; line-height: 1.7;">
                Maskarebat Green Garden bekerja sama dengan berbagai bank terpercaya untuk memberikan kemudahan bagi Anda dalam memiliki rumah impian dengan skema KPR yang menguntungkan dan proses yang mudah.
            </p>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
function calculateKPR() {
    const propertyPrice = parseFloat(document.getElementById('propertyPrice').value) || 0;
    const downPaymentAmount = parseFloat(document.getElementById('downPayment').value.replace(/[^0-9]/g, '')) || 0;
    const loanTerm = parseInt(document.getElementById('loanTerm').value) || 0;
    const interestRate = parseFloat(document.getElementById('interestRate').value) || 0;

    if (propertyPrice === 0 || loanTerm === 0) {
        alert('Mohon lengkapi data yang diperlukan');
        return;
    }

    const downPayment = downPaymentAmount || (propertyPrice * 0.2); // Default 20% if not specified
    const loanAmount = propertyPrice - downPayment;
    const monthlyRate = (interestRate / 100) / 12;
    const numberOfPayments = loanTerm * 12;

    // Calculate monthly payment using loan formula
    const monthlyPayment = loanAmount * (monthlyRate * Math.pow(1 + monthlyRate, numberOfPayments)) / 
                         (Math.pow(1 + monthlyRate, numberOfPayments) - 1);

    // Update results
    document.getElementById('resultHousePrice').textContent = formatCurrency(propertyPrice);
    document.getElementById('resultDownPayment').textContent = formatCurrency(downPayment);
    document.getElementById('resultLoanAmount').textContent = formatCurrency(loanAmount);
    document.getElementById('resultLoanTerm').textContent = loanTerm + ' Tahun';
    document.getElementById('resultInterestRate').textContent = interestRate + '%';
    document.getElementById('monthlyPaymentAmount').textContent = formatCurrency(monthlyPayment);

    // Update down payment percentage
    const downPaymentPercent = ((downPayment / propertyPrice) * 100).toFixed(1);
    document.getElementById('downPaymentPercent').value = downPaymentPercent;
}

function formatCurrency(amount) {
    return 'Rp ' + amount.toLocaleString('id-ID');
}

// Auto-calculate down payment percentage when amount changes
document.getElementById('downPayment').addEventListener('input', function() {
    const propertyPrice = parseFloat(document.getElementById('propertyPrice').value) || 0;
    const downPaymentAmount = parseFloat(this.value.replace(/[^0-9]/g, '')) || 0;
    
    if (propertyPrice > 0 && downPaymentAmount > 0) {
        const percentage = ((downPaymentAmount / propertyPrice) * 100).toFixed(1);
        document.getElementById('downPaymentPercent').value = percentage;
    }
});

// Auto-calculate down payment amount when percentage changes
document.getElementById('downPaymentPercent').addEventListener('input', function() {
    const propertyPrice = parseFloat(document.getElementById('propertyPrice').value) || 0;
    const percentage = parseFloat(this.value) || 0;
    
    if (propertyPrice > 0 && percentage > 0) {
        const amount = (propertyPrice * percentage / 100);
        document.getElementById('downPayment').value = formatCurrency(amount);
    }
});
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\programming\web-perumahan\resources\views/frontend/simulasi-kpr.blade.php ENDPATH**/ ?>