@extends('layouts.app')
@section('content')

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Arial', sans-serif;
        line-height: 1.6;
    }

    /* Top Navigation Bar */
    .top-navbar {
        background-color: #1a1a1a;
        padding: 0.3rem 0;
        font-size: 0.8rem;
    }

    .top-navbar .container {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .top-navbar .contact-info {
        color: #ccc;
    }

    .top-navbar .social-links a {
        color: #ccc;
        margin-left: 1rem;
        font-size: 0.9rem;
    }

    /* Main Navigation */
    .main-navbar {
        background-color: #ffffff;
        padding: 1rem 0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .navbar-brand {
        color: #4CAF50 !important;
        font-weight: bold;
        font-size: 1.1rem;
        display: flex;
        align-items: center;
    }

    .navbar-brand i {
        color: #4CAF50;
        margin-right: 8px;
        font-size: 1.2rem;
    }

    .main-navbar .navbar-nav {
        margin: 0 auto;
    }

    .main-navbar .navbar-nav .nav-link {
        color: #333 !important;
        margin: 0 1.5rem;
        font-size: 0.95rem;
        font-weight: 500;
        padding: 0.5rem 0;
    }

    .main-navbar .navbar-nav .nav-link:hover {
        color: #4CAF50 !important;
    }

    .btn-hubungi {
        background-color: #ff5722;
        color: white;
        border: none;
        padding: 0.6rem 1.8rem;
        border-radius: 25px;
        font-size: 0.9rem;
        font-weight: 600;
    }

    .btn-hubungi:hover {
        background-color: #e64a19;
        color: white;
    }

    /* Hero Section */
    .hero-section {
        background: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.6)), 
                    url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 500"><rect fill="%23222" width="1200" height="500"/><rect fill="%23333" x="800" y="150" width="300" height="200" rx="10"/><rect fill="%23444" x="820" y="170" width="50" height="80"/><rect fill="%23444" x="890" y="170" width="50" height="80"/><rect fill="%23555" x="810" y="280" width="280" height="20"/></svg>');
        background-size: cover;
        background-position: center;
        color: white;
        padding: 4rem 0 5rem;
        min-height: 500px;
    }

    .hero-content h1 {
        font-size: 3.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        letter-spacing: -1px;
    }

    .hero-content .subtitle {
        font-size: 1.3rem;
        margin-bottom: 0.3rem;
        font-weight: 400;
    }

    .hero-content .features {
        font-size: 1.2rem;
        margin-bottom: 0.3rem;
        font-weight: 500;
    }

    .hero-content .highlight {
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 2rem;
        color: #ffeb3b;
    }

    /* Why Choose Section */
    .why-section {
        padding: 4rem 0;
        background-color: #fafafa;
    }

    .section-header {
        text-align: center;
        margin-bottom: 1rem;
    }

    .section-header .question {
        color: #ff5722;
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }

    .section-header .main-title {
        color: #333;
        font-size: 2.2rem;
        font-weight: 700;
        margin-bottom: 3rem;
    }

    .feature-card {
        background: white;
        padding: 2.5rem 1.5rem;
        border-radius: 8px;
        text-align: center;
        box-shadow: 0 2px 15px rgba(0,0,0,0.08);
        margin-bottom: 2rem;
        height: 100%;
    }

    .feature-icon {
        width: 80px;
        height: 80px;
        background-color: #e3f2fd;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1.5rem;
    }

    .feature-icon i {
        font-size: 2.2rem;
        color: #2196f3;
    }

    .feature-card h4 {
        font-size: 1.2rem;
        font-weight: 600;
        margin-bottom: 1rem;
        color: #333;
    }

    .feature-card p {
        font-size: 0.95rem;
        color: #666;
        line-height: 1.6;
    }

    /* About Section */
    .about-section {
        background-color: #e8f5e8;
        padding: 4rem 0;
    }

    .about-label {
        color: #666;
        font-size: 1rem;
        margin-bottom: 0.5rem;
        font-weight: 500;
    }

    .about-title {
        font-size: 2.8rem;
        font-weight: 700;
        color: #333;
        margin-bottom: 2rem;
        line-height: 1.2;
    }

    .about-text {
        font-size: 1rem;
        color: #555;
        line-height: 1.7;
        margin-bottom: 1.5rem;
    }

    .about-image {
        width: 100%;
        border-radius: 10px;
        box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    }

    .btn-broker {
        background-color: #ff5722;
        color: white;
        border: none;
        padding: 0.8rem 2rem;
        border-radius: 25px;
        font-weight: 600;
        margin-top: 1rem;
    }

    /* Facilities Section - Updated Layout */
    .facilities-section {
        padding: 4rem 0;
        background-color: white;
    }

    .facilities-title {
        text-align: center;
        margin-bottom: 3rem;
    }

    .facilities-title .subtitle {
        color: #4CAF50;
        font-size: 1.1rem;
        margin-bottom: 0.5rem;
        font-weight: 600;
    }

    .facilities-title .main {
        color: #333;
        font-size: 2.2rem;
        font-weight: 700;
    }

    .main-facility {
        position: relative;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        height: 400px;
    }

    .main-facility-image {
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, #4CAF50, #81C784);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.5rem;
        font-weight: 700;
        position: relative;
    }

    .main-facility-label {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: rgba(0,0,0,0.8);
        color: white;
        padding: 1.2rem;
        text-align: center;
        font-weight: 700;
        font-size: 1.1rem;
    }

    .small-facility {
        position: relative;
        border-radius: 10px;
        overflow: hidden;
        margin-bottom: 1rem;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        /* height: 120px; */
        height: 185px;
    }

    .small-facility-image {
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, #2196F3, #64B5F6);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 0.9rem;
        font-weight: 600;
    }

    .small-facility-label {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: rgba(0,0,0,0.8);
        color: white;
        padding: 0.5rem;
        text-align: center;
        font-weight: 600;
        font-size: 0.8rem;
    }

    /* Hot Sale Section - Complete */
    .hot-sale-section {
        background-color: #e8f5e8;
        padding: 4rem 0;
    }

    .hot-sale-header {
        text-align: center;
        margin-bottom: 3rem;
    }

    .hot-sale-label {
        color: #ff5722;
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }

    .hot-sale-title {
        color: #333;
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .hot-sale-subtitle {
        color: #666;
        font-size: 1rem;
    }

    .house-card {
        background: white;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        margin-bottom: 2rem;
    }

    .house-image {
        width: 100%;
        height: 400px;
        background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        overflow: hidden;
    }

    .house-image::before {
        content: '';
        position: absolute;
        width: 150px;
        height: 100px;
        background: #bdbdbd;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .house-card-body {
        padding: 2rem;
    }

    .house-type {
        font-size: 1.4rem;
        font-weight: 700;
        color: #333;
        margin-bottom: 1.5rem;
        text-align: center;
    }

    .house-specs {
        background-color: #f8f9fa;
        padding: 1.5rem;
        border-radius: 10px;
        margin-bottom: 1.5rem;
    }

    .spec-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 0.8rem;
        font-size: 0.9rem;
    }

    .spec-row:last-child {
        margin-bottom: 0;
    }

    .spec-label {
        color: #666;
        font-weight: 500;
    }

    .spec-value {
        color: #333;
        font-weight: 600;
    }

    .price-section {
        text-align: center;
        margin-bottom: 1.5rem;
    }

    .price-amount {
        font-size: 1.3rem;
        font-weight: 700;
        color: #ff5722;
        margin-bottom: 0.3rem;
    }

    .price-note {
        font-size: 0.85rem;
        color: #666;
    }

    .btn-booking {
        width: 100%;
        padding: 0.8rem;
        border-radius: 8px;
        font-weight: 600;
        margin-bottom: 0.8rem;
        border: none;
        font-size: 0.95rem;
    }

    .btn-orange {
        background-color: #ff5722;
        color: white;
    }

    .btn-blue {
        background-color: #2196f3;
        color: white;
    }

    .consultation-btn {
        text-align: center;
        margin-top: 3rem;
    }

    .btn-consultation {
        background-color: #ff5722;
        color: white;
        border: none;
        padding: 1rem 3rem;
        border-radius: 25px;
        font-weight: 600;
        font-size: 1rem;
    }

    /* Special Offer Section */
    .special-offer-section {
        padding: 4rem 0;
        background-color: white;
    }

    .offer-title {
        font-size: 2.2rem;
        font-weight: 700;
        color: #4CAF50;
        margin-bottom: 0.5rem;
    }

    .offer-subtitle {
        font-size: 2.2rem;
        font-weight: 700;
        color: #333;
        margin-bottom: 2rem;
    }

    .promo-features {
        margin: 2rem 0;
    }

    .feature-item {
        display: flex;
        align-items: center;
        margin-bottom: 0.8rem;
    }

    .feature-item i {
        color: #4CAF50;
        margin-right: 0.8rem;
        font-size: 1.1rem;
    }

    .feature-item span {
        font-size: 0.95rem;
        color: #333;
    }

    .discount-banner {
        background: linear-gradient(135deg, #ff5722, #ff7043);
        color: white;
        padding: 2rem;
        border-radius: 15px;
        text-align: center;
        margin-bottom: 2rem;
        position: relative;
        overflow: hidden;
    }

    .discount-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .discount-amount {
        font-size: 3rem;
        font-weight: 900;
        margin-bottom: 0.5rem;
    }

    .discount-note {
        font-size: 1rem;
        opacity: 0.9;
    }

    .offer-image {
        width: 100%;
        border-radius: 10px;
        /* box-shadow: 0 6px 20px rgba(0,0,0,0.1); */
        max-height: 512px;
        object-fit: contain;
    }

    /* Footer */
    .footer {
        background-color: #1a1a1a;
        color: #ccc;
        padding: 3rem 0 1rem;
    }

    .footer h5 {
        color: #4CAF50;
        font-size: 1.2rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
    }

    .footer p, .footer li {
        font-size: 0.9rem;
        line-height: 1.6;
        margin-bottom: 0.5rem;
    }

    .footer a {
        color: #ccc;
        text-decoration: none;
    }

    .footer a:hover {
        color: #4CAF50;
    }

    .footer .social-icons a {
        color: #4CAF50;
        font-size: 1.5rem;
        margin-right: 1rem;
    }

    .footer-bottom {
        border-top: 1px solid #333;
        margin-top: 2rem;
        padding-top: 1rem;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .hero-content h1 {
            font-size: 2.5rem;
        }
        
        .about-title {
            font-size: 2rem;
        }
        
        .hot-sale-title {
            font-size: 1.8rem;
        }
        
        .main-navbar .navbar-nav .nav-link {
            margin: 0 0.5rem;
        }

        .main-facility {
            height: 250px;
            margin-bottom: 2rem;
        }

        .small-facility {
            height: 100px;
        }
    }
</style>

<!-- Hero Section -->
<section class="hero-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-7">
                <div class="hero-content">
                    <h1>Rumah 1 Lantai</h1>
                    <p class="subtitle mt-3">Luas Tanah Terbesar di Palembang</p>
                    <p class="features mt-3">Murah, Nyaman, & Strategis</p>
                    <p class="highlight mt-3">TANPA DP, GRATIS BIAYA KPR, GRATIS SHM</p>
                    <button class="btn btn-hubungi btn-lg">Hubungi Kami</button>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why Choose Section -->
<section class="why-section">
    <div class="container">
        <div class="section-header">
            <p class="question">Kenapa Harus di Maskarebat Green Garden ?</p>
            <h2 class="main-title">Lokasi Strategis di Palembang</h2>
        </div>
        <div class="row">
            <div class="col-lg-4">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-building"></i>
                    </div>
                    <h4>Fasilitas Kapitalitas</h4>
                    <p>Akses mudah menuju berbagai fasilitas umum seperti sekolah, rumah sakit, dan pusat perbelanjaan untuk kenyamanan hidup sehari-hari.</p>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-plane"></i>
                    </div>
                    <h4>Dekat Bandara</h4>
                    <p>Lokasi strategis dekat dengan bandara Sultan Mahmud Badaruddin II memberikan kemudahan akses transportasi udara.</p>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-briefcase"></i>
                    </div>
                    <h4>Pusat Perkantoran</h4>
                    <p>Berdekatan dengan pusat bisnis dan perkantoran memudahkan aktivitas kerja dan pengembangan bisnis Anda.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- About Section -->
<section class="about-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5">
                <img style="width: 70%;" src="{{ asset('tentang-kami.png') }}" alt="Maskarebat Green Garden House" class="about-image">
            </div>
            <div class="col-lg-7">
                <p class="about-label" style="color: #81987E; font-size: 1.5rem; font-weight: bold;">Tentang Kami</p>
                <h2 class="about-title">Maskarebat Green Garden</h2>
                <p class="about-text">Maskarebat Green Garden adalah perumahan modern yang menawarkan hunian berkualitas dengan konsep ramah lingkungan. Terletak di lokasi strategis Palembang, perumahan ini menyediakan berbagai fasilitas lengkap untuk kenyamanan keluarga Anda.</p>
                
                <p class="about-text">Dengan desain rumah yang modern dan fungsional, setiap unit dilengkapi dengan spesifikasi bangunan berkualitas tinggi. Lingkungan yang asri dan aman menjadikan Maskarebat Green Garden pilihan tepat untuk investasi masa depan keluarga.</p>
                
                <p class="about-text">Nikmati kemudahan akses ke berbagai fasilitas umum seperti sekolah, rumah sakit, pusat perbelanjaan, dan tempat ibadah. Sistem keamanan 24 jam dan lingkungan yang bersih membuat Anda merasa nyaman tinggal di sini.</p>
                
                <button class="btn btn-broker">Minta Brosur</button>
            </div>
        </div>
    </div>
</section>

<!-- Facilities Section -->
<section class="facilities-section">
    <div class="container">
        <div class="facilities-title">
            <p class="subtitle">Untuk Anda</p>
            <h2 class="main">Fasilitas di Sekitar Perumahan</h2>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <div class="main-facility">
                    <div class="main-facility-image"><img src="{{ asset('image1.png') }}" alt="Masjid" style="width:100%;height:auto;object-fit:cover;"></div>
                    <div class="main-facility-label">Amanzi Waterpark</div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="row">
                    <div class="col-6">
                        <div class="small-facility">
                            <div class="small-facility-image"><img src="{{ asset('image2.png') }}" alt="Masjid" style="width:100%;height:auto;object-fit:cover;"></div>
                            <div class="small-facility-label">Masjid Darul Muttaqin</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="small-facility">
                            <div class="small-facility-image"><img src="{{ asset('image3.png') }}" alt="Alfamart & Indomaret" style="width:100%;height:auto;object-fit:cover;"></div>
                            <div class="small-facility-label">Alfamart & Indomaret</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="small-facility">
                            <div class="small-facility-image"><img src="{{ asset('image4.png') }}" alt="Sekolah" style="width:100%;height:auto;object-fit:cover;"></div>
                            <div class="small-facility-label">JM Sukarami</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="small-facility">
                            <div class="small-facility-image"><img src="{{ asset('image5.png') }}" alt="Rumah Sakit Bukit" style="width:100%;height:auto;object-fit:cover;"></div>
                            <div class="small-facility-label">Taman Maskarebat</div>
                        </div>
                    </div>
                    <!-- <div class="col-12">
                        <div class="small-facility">
                            <div class="small-facility-image"><img src="{{ asset('image5.png') }}" alt="Rumah Maskarebat" style="width:100%;height:auto;object-fit:cover;"></div>
                            <div class="small-facility-label">Taman Maskarebat</div>
                        </div>
                    </div> -->
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Hot Sale Section -->
<section class="hot-sale-section">
    <div class="container">
        <div class="hot-sale-header">
            <p class="hot-sale-label">Hot Sale</p>
            <h2 class="hot-sale-title">Bersama Kami Keluarga MGG</h2>
            <p class="hot-sale-subtitle">Rumah Modern Minimalis paling laris masih tersedia tipe ideal terbaik.</p>
        </div>
        
        <div class="row">
            <div class="col-lg-6">
                <div class="house-card">
                    <div class="house-image"><img src="{{ asset('rumah1.png') }}" alt="Rumah" style="width:100%;height:auto;object-fit:cover;"></div>
                    <div class="house-card-body">
                        <h3 class="house-type">Type 36/102</h3>
                        <div class="house-specs">
                            <div class="spec-row">
                                <span class="spec-label">Luas Bangunan</span>
                                <span class="spec-value">36 m²</span>
                            </div>
                            <div class="spec-row">
                                <span class="spec-label">Luas Tanah</span>
                                <span class="spec-value">102 m²</span>
                            </div>
                            <div class="spec-row">
                                <span class="spec-label">Kamar Tidur</span>
                                <span class="spec-value">2</span>
                            </div>
                            <div class="spec-row">
                                <span class="spec-label">Kamar Mandi</span>
                                <span class="spec-value">1</span>
                            </div>
                        </div>
                        <div class="price-section">
                            <div class="price-amount">Rp 2 Jutaan</div>
                            <div class="price-note">Cicilan per bulan mulai dari</div>
                        </div>
                        <a href="{{ route('type-36') }}" class="btn btn-booking btn-orange">Selengkapnya</a>
                        <a href="{{ route('simulasi-kpr') }}" class="btn btn-booking btn-blue">Simulasi KPR</a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="house-card">
                    <div class="house-image"><img src="{{ asset('rumah2.png') }}" alt="Rumah" style="width:100%;height:auto;object-fit:cover;"></div>
                    <div class="house-card-body">
                        <h3 class="house-type">Type 54/120</h3>
                        <div class="house-specs">
                            <div class="spec-row">
                                <span class="spec-label">Luas Bangunan</span>
                                <span class="spec-value">54 m²</span>
                            </div>
                            <div class="spec-row">
                                <span class="spec-label">Luas Tanah</span>
                                <span class="spec-value">120 m²</span>
                            </div>
                            <div class="spec-row">
                                <span class="spec-label">Kamar Tidur</span>
                                <span class="spec-value">3</span>
                            </div>
                            <div class="spec-row">
                                <span class="spec-label">Kamar Mandi</span>
                                <span class="spec-value">2</span>
                            </div>
                        </div>
                        <div class="price-section">
                            <div class="price-amount">Rp 3 Jutaan</div>
                            <div class="price-note">Cicilan per bulan mulai dari</div>
                        </div>
                        <a href="{{ route('type-54') }}" class="btn btn-booking btn-orange">Selengkapnya</a>
                        <a href="{{ route('simulasi-kpr') }}" class="btn btn-booking btn-blue">Simulasi KPR</a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="consultation-btn">
            <button class="btn btn-consultation">Konsultasi dengan kami untuk rumah impian Anda</button>
        </div>
    </div>
</section>

<!-- Special Offer Section -->
<section class="special-offer-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h2 class="offer-title">Dapatkan Sekarang</h2>
                <h3 class="offer-subtitle">Sebelum Harga Naik !</h3>
                
                <button class="btn btn-blue mb-3">Booking Sekarang</button>
                <p><strong>Promo Terbatas Ini!</strong></p>
                <p class="mb-4">Dapatkan Promo, Booking cuman 1 Jt bisa dapetin rumah impian!</p>
                
                <div class="promo-features">
                    <div class="row">
                        <div class="col-6">
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Tanpa DP</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Gratis Biaya Pajak</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Air Conditioner (AC)</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Gratis SHM</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>TV 32 Inch</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Subsidi Angsuran 1 tahun</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <button class="btn btn-hubungi btn-lg mt-3">Hubungi Kami</button>
            </div>
            <div class="col-lg-6">
                <!-- <div class="discount-banner">
                    <div class="discount-title">DISKON SPESIAL</div>
                    <div class="discount-amount">110 JUTA</div>
                    <div class="discount-note">Berlaku sampai 31 Desember 2024</div>
                </div> -->
                <img src="{{ asset('diskon.png') }}" alt="Special Offer House" class="offer-image">
            </div>
        </div>
    </div>
</section>

@endsection 