@section('title', 'Tipe 36')
<x-admin>
    <div class="container">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="font-weight-bold">Status</h3>
                    <a href="{{ route('admin.tipe36.create') }}" class="btn btn-outline-secondary">Tambah Unit</a>
                </div>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Blok</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($units as $unit)
                        <tr>
                            <td>{{ $unit->blok }}</td>
                            <td>{{ $unit->status }}</td>
                            <td><a href="{{ route('admin.tipe36.edit', $unit->id) }}" class="btn btn-primary btn-sm">Lihat/edit</a></td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="3" class="text-center text-muted">Belum ada unit Tipe 36 yang terdaftar.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</x-admin>