<form method="POST" action="{{ $action }}">
    @csrf
    @if($isEdit)
        @method('PUT')
    @endif
    <div class="mb-3">
        <label class="font-weight-bold">Jabatan</label>
        <input type="text" name="jabatan" class="form-control" placeholder="Misalkan, marketing executive" value="{{ old('jabatan', $karir->jabatan ?? '') }}">
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Status</label>
        <select name="status" class="form-control">
            <option value="">Pilih status pekerjaan saat ini</option>
            <option value="Open" {{ old('status', $karir->status ?? '') == 'Open' ? 'selected' : '' }}>Open</option>
            <option value="Closed" {{ old('status', $karir->status ?? '') == 'Closed' ? 'selected' : '' }}>Closed</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Tentang Pekerjaan</label>
        <input type="text" name="tentang" class="form-control" placeholder="Misalkan, jabatan ini bertugas sebagai ......" value="{{ old('tentang', $karir->tentang ?? '') }}">
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Insentif</label>
        <input type="text" name="insentif" class="form-control" placeholder="Misalkan, Rp 1.500.000" value="{{ old('insentif', $karir->insentif ?? '') }}">
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Syarat</label>
        <input type="text" name="syarat" class="form-control" placeholder="Misalkan, fotocopy KTP" value="{{ old('syarat', $karir->syarat ?? '') }}">
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Cara Mendaftar</label>
        <input type="text" name="cara_mendaftar" class="form-control" placeholder="Misalkan, hubungi ke nomor berikut ......" value="{{ old('cara_mendaftar', $karir->cara_mendaftar ?? '') }}">
    </div>
    <div class="text-right">
        <button type="submit" class="btn btn-warning">SIMPAN</button>
    </div>
</form> 